require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

closed = false;

MakeDialog
{
	name = "prelevel_dialog",
	Window{
	    name = "prelevel_container",
	    alpha = true,
	    x = 0, y = 0, w = 800, h = 600,
	    
	    VTintWindow{
	        x = 0, y = 0, w = 800, h = 600,
	        color = Color(0,0,0,160),
	        fade = true,
	    },
    --------------------------------------------------- Prelevel Window
	    VPrelevelWindow {
	        name = "prelevel_window",

            --image = "ui/prelevel/background.png",
            x = 0, y = 600, w = 800, h = 600,
            targetposx = 0, targetposy = 0,
            bouncelen = 400, bouncefunc = "sincx",
            alpha = true,
    		
    		
            KSplit9Image{
			    image = "ui/prelevel/list_back",
			    x1 = 1,
			    y1 = 1,
			    x2 = 1,
			    y2 = 1,
			    x = 62,
			    y = 152,
			    w = 261,
			    h = 277,
			},
	    ----------------------------------------------- Scrollable Upgrade List
            
	        
            VUpgradeList {
		        name = "upgrade_list",
		        x = 62,
		        y = 152,
		        w = 261,
		        h = 277,
		        --bgcolor = Color(99,28,41),
    			tick = 43,
    			
		        SetStyle(CSUpgrade_SliderStyle),
		        Button{
		            name = "slider_start",
	                x = kMax - 26, y = 0,
	                graphics = {"ui/slider/prelevel_start", "ui/slider/prelevel_start_over", "ui/slider/prelevel_start_over" },
	                --image = "ui/slider/prelevel_start",
	            },
		        Button{
		            name = "slider_end",
	                x = kMax - 26, y = kMax - 22,
	                graphics = {"ui/slider/prelevel_end", "ui/slider/prelevel_end_over", "ui/slider/prelevel_end_over" },
	                --image = "ui/slider/prelevel_end",
	            },
	            except = {"slider_end", "slider_start"},
		        TSlider{
			        x = kMax - 26,
			        y = 22,
			        h = kMax - 22,
			        w = 25,
			        name = "upgrade_slider",
		        },
	        },
	        Bitmap{
	            name = "prelevel_background",
		        x = 13, y = 3, w = kMax, h = kMax,
		        image = "ui/prelevel/background",
		        mask = "ui/prelevel/background.mask",
		        alpha = true,
		    },
	    ----------------------------------------------- Selection Buttons
		    SetStyle(App_MenuButtonStyle),
		    BeginGroup(),
		    RDisableButton {
			    x = 51,
			    y = 77,
			    w = 113 * 0.93,
			    h = 74 * 0.93,
			    scale = 0.93,
			    type = kRadio,
			    name = "toggle_upgrades_aesthetic",
			    graphics = {"ui/buttons/oval_green_up", "ui/buttons/oval_green_down", "ui/buttons/oval_green_down", "anim/transparent"},
			    SelectLayer(3),
			    RWindow{
			        scale = 0.93,
			        --imagealpha = 0.7;
			        x = 0, y = 0, image = "ui/buttons/oval_disabled",
			    },
			    SelectLayer(-1),
			    Text{
				    font = Prelevel_SmallFont, 
				    x = 0, y = 0,
				    h = kMax, w = kMax,
				    flags = kHAlignCenter + kVAlignCenter,
				    label = "prelevel_decoration",
			    },
		    },
		    RDisableButton {
			    x = 138,
			    y = 77,
			    w = 113 * 0.93,
			    h = 74 * 0.93,
			    scale = 0.93,
			    type = kRadio,
			    name = "toggle_upgrades_gameplay",
			    graphics = {"ui/buttons/oval_purple_up", "ui/buttons/oval_purple_down", "ui/buttons/oval_purple_down", "anim/transparent"},
			    SelectLayer(3),
			    RWindow{
			        scale = 0.93,
			        --imagealpha = 0.7;
			        x = 0, y = 0, image = "ui/buttons/oval_disabled",
			    },
			    SelectLayer(-1),
			    Text{
				    font = Prelevel_SmallFont,
				    x = 0,
				    y = 0,
				    h = kMax,
				    w = kMax,
				    flags = kHAlignCenter + kVAlignCenter,
				    label = "prelevel_machines",
			    },
		    },
		    RDisableButton {
			    x = 225,
			    y = 77,
			    w = 113 * 0.93,
			    h = 74 * 0.93,
			    scale = 0.93,
			    type = kRadio,
			    name = "toggle_upgrades_player",
			    graphics = {"ui/buttons/oval_lt_blue_up", "ui/buttons/oval_lt_blue_down", "ui/buttons/oval_lt_blue_down", "anim/transparent"},
			    SelectLayer(3),
			    RWindow{
			        scale = 0.93,
			        --imagealpha = 0.7;
			        x = 0, y = 0, image = "ui/buttons/oval_disabled",
			    },
			    SelectLayer(-1),
			    Text{
				    font = Prelevel_SmallFont,
				    x = 0,
				    y = 0,
				    h = kMax,
				    w = kMax,
				    flags = kHAlignCenter + kVAlignCenter,
				    label = "prelevel_powerups",
			    },
		    },
    		
		    ----------------------------------------------- BUY button
		    --[[Button{
			    name = "btn_buy",
			    x = 628,
			    y = 393, 
			    w = 120,
			    h = 105,
			    Text{
				    font = Prelevel_MediumFont,
				    w = kMax, h = kMax,
				    flags = kHAlignCenter + kVAlignCenter,
				    label = "prelevel_buy",
			    },
			    graphics = { "ui/prelevel/buy_up","ui/prelevel/buy_down","ui/prelevel/buy_down" },
			    command = 
				    function()
				    end
		    },]]
    		
		    --------------------------------- Upgrade Shop
		    ---------shadow
		    Text{
			    font = Prelevel_TitleShadowFont,
			    x = 168 + 2, y = 19 + 2,
			    w = 468, h = 58,
			    flags = kHAlignCenter + kVAlignCenter,
			    label = "prelevel_title",
		    },
		    Text{
			    font = Prelevel_TitleFont,
			    x = 168, y = 19,
			    w = 468, h = 58,
			    flags = kHAlignCenter + kVAlignCenter,
			    label = "prelevel_title",
		    },
	    },
    		
        RBounceWindow{
            name = "quit_button",
            x = kCenter - 537, y = 600 - 238,
            image = "ui/endlevel/trim_left",
            mask = "ui/endlevel/trim_left.mask",
            targetposx = 0, targetposy = 600 - 238,
            SetStyle(App_MenuButtonStyle),
            alpha = true,
            SetStyle(CSMMRight2ButtonStyle),
	        Button{
		        x = 3, y = 135, 
                hflip = true,
		        Text{
		            x = 10, y = 0,
			        w = kMax, h = kMax - 10,
				    font = {edwardian_medium, 20, WhiteColor},
			        flags = kHAlignCenter + kVAlignCenter,
			        label = "app_quit",
		        },
		        command = 
			        function()
				        SetQuitting(true);
			            if(GetCurrentGameMode() == 0) then
			                result = DisplayDialog{ "scripts/yesno.lua", body = "quit_game_body", header = "", width=390, height=280 };
			            else
			                result = DisplayDialog{ "scripts/yesno.lua", body = "quit_endless_body", header = "", width=390, height=280 };
			            end
			            if(result == "yes") then
			                --if(not closed) then
			                    --closed = true;
			                    Close();
			                    SetState("UpgradeScreenTime", 0);
			                    PostMessage( CreateNamedMessage( kTintOff, "" ) );
			                    DoTransition( kBounceBack );
			                    DoTransition( kFadeToBlack );
			                    QuitToMainMenu();
				            --end
				        end
				        SetQuitting(false);
			        end
	        },
        },
        RBounceWindow{
            x = 800, y = 600 - 238,
            image = "ui/endlevel/trim_left",
            mask = "ui/endlevel/trim_left.mask",
            targetposx = 800 - 137, targetposy = 600 - 238,
            alpha = true,
            hflip = true,
            SetStyle(CSMMRight2ButtonStyle),
            Button{
                name = "ok_button",
		        x = 15, y = 135, 
		        Text{
			        w = kMax - 10, h = kMax - 10,
				    font = {edwardian_medium, 20, WhiteColor},
			        flags = kHAlignCenter + kVAlignCenter,
			        label = "map_play",
		        },
		        command = 
			        function()
			            --if(not closed) then
			                --closed = true;
			                InsideGame(true);
			                Close();
			                SetState("UpgradeScreenTime", 0);
			                PostMessage( CreateNamedMessage( kTintOff, "" ) );
			                DoTransition( kBounceBack );
			                PauseSounds(false, kSFXSoundGroup); 
			                CloseWindow();
				        --end
			        end
	        },
        },
        RBounceWindow{
            x = 141, y = 600,
            targetposx = 141, targetposy = 445,
            image = "ui/endlevel/trim_bottom",
	        mask = "ui/endlevel/trim_bottom.mask",
            alpha = true,
    	    
            Text {
                x = 0, y = 7, w = 167, h = 38,
                flags = kHAlignRight + kVAlignCenter,
                font = {edwardian_medium, 28, BlackColor},
                label = "#Cash:",
            },
    	    
            Text {
                x = 122, y = 73, w = 370, h = 75,
                name = "txt_extra_info",
                font = {edwardian_medium, 14, BlackColor},
                flags = kHAlignLeft + kVAlignTop,
                label = "prelevel_blurb_1",
            },
    	    
            Bitmap{
	            x = 26, y = 35,
	            image = "anim/portraits/evangeline_small",
	        },
    	    
	        Text{
		        font = {edwardian_medium,36,WhiteColor},
		        x = 170, y = 4,
		        w = 50, h = 50,
		        flags = kHAlignCenter + kVAlignCenter,
		        label = "#$",
	        },
    	    
            VRegister{
                x = 175, y = 20, w = 260, h = 38,
                numDigits = 7,
                context = "prelevel",
		        digit = {
		            font = {edwardian_medium, 25, WhiteColor},
		            x = 0,
		            y = 0,
		            w = 15,
		            h = 25,
		        },
            },
            Bitmap{
                x = 0, y = 0,
                image = "ui/endlevel/trim_bottom_highlight.png",
            },
        },
    },
}
InsideGame(false);
SetState("UpgradeScreenTime", 1);
PauseSounds(true, kSFXSoundGroup);